-- Author Pasky13

local camx = 0x38F
local camy = 0x3CF

local plife = 0x440
local px = 0x370
local py = 0x3A0

local ex = 0x370
local ey = 0x3A0

--Configurable player box
local pxrad = 6  -- Only use multiples of 2 and no higher than 6

local function hex(val)
	val = string.format("%X",val)
	return val
end

local function draw_axis(x,y,color)
	gui.line(x,y-4,x,y+4,color)
	gui.line(x-4,y,x+4,y,color)
end

local function lookup(etype,i)  -- this is really messy GIANT if else statement incoming
	local box = {0,0,0,0} -- xoff,yoff,xrad,yrad
	if etype == 0xF then
		box = {0x06,0x18,0x0C,0x18}
	elseif etype == 0x4A then	
		box = {0x1C,0x0C,0x38,0x18}
	elseif etype == 0x1B then
		box = {0x08,0x08,0x10,0x10}
	elseif etype == 0x13 then
		box = {0x08,0x10,0x10,0x20}
	elseif etype == 0x3F then
		box = {0x0C,0x38,0x18,0x38}
	elseif etype == 0x40 then
		box = {0x07,0x07,0x0E,0x0E}
	elseif etype == 0x12 then
		box = {0x04,0x04,0x08,0x08}
	elseif etype == 0x36 then
		box = {0x10,0x10,0x20,0x20}
	elseif etype == 0x30 then
		box = {0x0C,0x10,0x18,0x18}
	elseif etype == 0x2C then
		box = {0x04,0x08,0x08,0x08}
	elseif etype == 0x2B then
		box = {0x08,0x08,0x10,0x18}
	elseif etype == 0x24 then
		box = {0x08,0x08,0x10,0x10}
	elseif etype == 0x25 then
		box = {0x04,0x08,0x08,0x08}
	elseif etype == 0x46 then
		box = {0x18,0x20,0x28,0x20}
	elseif etype == 0x1E then
		box = {0x08,0x08,0x10,0x08}
	elseif etype == 0x50 then
		box = {0x10,0x00,0x40,0x60}
	elseif etype == 0x51 then
		box = {0x08,0x0A,0x10,0x0A}
	elseif etype == 0x32 then
		box = {0x08,0x10,0x10,0x10}
	elseif etype == 0x33 then
		box = {0x04,0x04,0x08,0x08}
	elseif etype == 0x42 then
		box = {0x04,0x04,0x08,0x08}
	elseif etype == 0x26 then
		box = {0x09,0x0D,0x15,0x15}
	elseif etype == 0x27 then
		box = {0x10,0x18,0x20,0x20}
	elseif etype == 0x28 then
		box = {0x04,0x04,0x08,0x08}
	elseif etype == 0x53 then
		box = {0x0C,0x20,0x18,0x28}
	elseif etype == 0x54 then
		box = {0x03,0x18,0x08,0x18}
	elseif etype == 0x48 then
		box = {0x0C,0x18,0x18,0x18}
	elseif etype == 0x49 then
		box = {0x08,0x08,0x08,0x08}
	elseif etype == 0x4A then
		box = {0x1C,0x0C,0x38,0x18}
	elseif etype == 0x4B then
		box = {0x05,0x04,0x08,0x08}
	elseif etype == 0x3D then
		box = {0x06,0x06,0x0C,0x0C}
	elseif etype == 0x3E then
		box = {0x06,0x06,0x0C,0x0C}
	elseif etype == 0x38 then
		box = {0x10,0x34,0x20,0x20}
	elseif etype == 0x57 then
		box = {0x00,0x00,0x48,0x60}
	elseif etype == 0x4D then
		box = {0x10,0x00,0x20,0x38}
	elseif etype == 0x59 then
		box = {0x0C,0x10,0x18,0x18}
	elseif etype == 0x58 then
		box = {0x08,0x08,0x10,0x10}
	elseif etype == 0x5E then
		box = {0x08,0x10,0x10,0x10}
	elseif etype == 0x37 then
		box = {0x10,0x28,0x24,0x50}
	elseif etype == 0x5D then
		box = {0x04,0x04,0x08,0x08}
	elseif etype == 0x5C then
		box = {0x08,0x08,0x10,0x10}
	elseif etype == 0x5B then
		box = {0x0C,0x00,0x18,0x10}
	elseif etype == 0x4C then	-- Mutating projectile
		o = mainmemory.read_u8(0x470 + i)
		dt = {0x08,0x0C,0x10,0x10,0x18,0x20}
		box = {0x04,0x08,dt[1+o],dt[4+o]}
	end
	
	return box
end

local function player()
	local pos = mainmemory.read_u8(0x300) 
	local cx = mainmemory.read_u8(camx) + (mainmemory.read_u8(camx + 0x10) * 256)
	local cy = mainmemory.read_u8(camy) + (mainmemory.read_u8(camy + 0x10) * 256)
	local x = mainmemory.read_u8(px) + (mainmemory.read_u8(px + 0x10) * 256) - cx
	local y = mainmemory.read_u8(py) + (mainmemory.read_u8(py + 0x10) * 256) - cy
	local pyrad = 0x1C
	
	if pos == 0x03 or pos == 0x06 then
		pyrad = 0x13
	end
	
	gui.drawBox(x - (pxrad / 2), y, x + (pxrad / 2), y - pyrad,0xFF0000FF,0x350000FF)
end

local function enemy()
	local cx = mainmemory.read_u8(camx) + (mainmemory.read_u8(camx + 0x10) * 256)
	local cy = mainmemory.read_u8(camy) + (mainmemory.read_u8(camy + 0x10) * 256)
	local etype
	local box = {0,0,0,0}
	
	for i = 6, 14, 1 do
		etype = mainmemory.read_u8(0x300 + i)
		local fill = 0x40FF0000
		local outl = 0xFFFF0000
		
		if etype ~= 0xFF then
			local x = mainmemory.read_u8(ex + i) + (mainmemory.read_u8(ex +  i + 0x10) * 256) - cx
			local y = mainmemory.read_u8(ey + i) + (mainmemory.read_u8(ey +  i + 0x10) * 256) - cy
			
			box = lookup(etype,i)
			
			gui.drawBox(x - box[1],y-box[2],x-box[1]+box[3] - pxrad,y-box[2]+box[4],outl,fill)
						
			if etype == 0x3F then-- 1st boss
				--Draw his vuln box
				local fill = 0x40FFFF00
				local outl = 0xFFFFFF00
				box = {0x0C,0x38,0x18,0x18}
				gui.drawBox(x - box[1],y-box[2],x-box[1]+box[3] - pxrad,y-box[2]+box[4],outl, fill)
			end
		end
	end
end

while true do
	player()
	enemy()
	emu.frameadvance()
end